<?php
// config.php
session_start();

define('DATA_DIR', 'data/');
define('USERS_FILE', DATA_DIR . 'users.txt');
define('MESSAGES_FILE', DATA_DIR . 'messages.txt');

// ایجاد دایرکتوری داده اگر وجود ندارد
if (!file_exists(DATA_DIR)) {
    mkdir(DATA_DIR, 0777, true);
}

// ایجاد فایل‌های داده اگر وجود ندارند
if (!file_exists(USERS_FILE)) {
    file_put_contents(USERS_FILE, '');
}
if (!file_exists(MESSAGES_FILE)) {
    file_put_contents(MESSAGES_FILE, '');
}

// دریافت IP کاربر
function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

// تولید شناسه دستگاه
function getDeviceId() {
    return md5(getUserIP() . $_SERVER['HTTP_USER_AGENT']);
}

// ذخیره کاربر
function saveUser($name) {
    $deviceId = getDeviceId();
    $users = getUsers();
    
    // بررسی وجود کاربر
    foreach ($users as $user) {
        if ($user['device_id'] === $deviceId) {
            $user['name'] = $name;
            $user['last_seen'] = time();
            saveUsers($users);
            return $user;
        }
    }
    
    // ایجاد کاربر جدید
    $newUser = [
        'id' => uniqid('user_'),
        'name' => $name,
        'device_id' => $deviceId,
        'ip' => getUserIP(),
        'created_at' => time(),
        'last_seen' => time()
    ];
    
    $users[] = $newUser;
    saveUsers($users);
    
    return $newUser;
}

// دریافت تمام کاربران
function getUsers() {
    if (!file_exists(USERS_FILE)) return [];
    
    $content = file_get_contents(USERS_FILE);
    if (empty($content)) return [];
    
    $users = [];
    $lines = explode("\n", $content);
    
    foreach ($lines as $line) {
        if (!empty(trim($line))) {
            $users[] = json_decode($line, true);
        }
    }
    
    return $users;
}

// ذخیره کاربران
function saveUsers($users) {
    $content = '';
    foreach ($users as $user) {
        $content .= json_encode($user, JSON_UNESCAPED_UNICODE) . "\n";
    }
    file_put_contents(USERS_FILE, $content);
}

// ذخیره پیام
function saveMessage($userId, $message, $isAdmin = false) {
    $messages = getMessages();
    
    $newMessage = [
        'id' => uniqid('msg_'),
        'user_id' => $userId,
        'message' => $message,
        'is_admin' => $isAdmin,
        'timestamp' => time()
    ];
    
    $messages[] = $newMessage;
    saveMessages($messages);
    
    return $newMessage;
}

// دریافت تمام پیام‌ها
function getMessages() {
    if (!file_exists(MESSAGES_FILE)) return [];
    
    $content = file_get_contents(MESSAGES_FILE);
    if (empty($content)) return [];
    
    $messages = [];
    $lines = explode("\n", $content);
    
    foreach ($lines as $line) {
        if (!empty(trim($line))) {
            $messages[] = json_decode($line, true);
        }
    }
    
    return $messages;
}

// ذخیره پیام‌ها
function saveMessages($messages) {
    $content = '';
    foreach ($messages as $message) {
        $content .= json_encode($message, JSON_UNESCAPED_UNICODE) . "\n";
    }
    file_put_contents(MESSAGES_FILE, $content);
}

// دریافت پیام‌های کاربر
function getUserMessages($userId) {
    $messages = getMessages();
    $userMessages = [];
    
    foreach ($messages as $message) {
        if ($message['user_id'] === $userId) {
            $userMessages[] = $message;
        }
    }
    
    return $userMessages;
}

// دریافت کاربر بر اساس شناسه
function getUserById($userId) {
    $users = getUsers();
    
    foreach ($users as $user) {
        if ($user['id'] === $userId) {
            return $user;
        }
    }
    
    return null;
}

// بررسی آیا کاربر لاگین کرده است
function isLoggedIn() {
    return isset($_SESSION['user']);
}

// بررسی آیا ادمین لاگین کرده است
function isAdminLoggedIn() {
    return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}
?>