<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Website Maintenance | We're Working on Your Orders</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, #1a2a6c, #b21f1f, #fdbb2d);
            background-size: 400% 400%;
            animation: gradientBG 15s ease infinite;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            color: #fff;
            overflow: hidden;
        }
        
        @keyframes gradientBG {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
        
        .container {
            text-align: center;
            max-width: 800px;
            padding: 40px;
            background: rgba(0, 0, 0, 0.7);
            border-radius: 20px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(20px);
            animation: fadeIn 1.5s ease-out;
            position: relative;
            overflow: hidden;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .container::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
            transform: rotate(0deg);
            animation: rotate 20s linear infinite;
            pointer-events: none;
        }
        
        @keyframes rotate {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
        
        .logo {
            margin-bottom: 30px;
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
        
        h1 {
            font-size: 3.5rem;
            margin-bottom: 20px;
            text-shadow: 3px 3px 10px rgba(0, 0, 0, 0.5);
            animation: slideInFromTop 1s ease-out;
        }
        
        @keyframes slideInFromTop {
            from { opacity: 0; transform: translateY(-50px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        p {
            font-size: 1.4rem;
            margin-bottom: 40px;
            line-height: 1.6;
            animation: slideInFromBottom 1s ease-out;
        }
        
        @keyframes slideInFromBottom {
            from { opacity: 0; transform: translateY(50px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .support-btn {
            display: inline-block;
            padding: 18px 42px;
            background: linear-gradient(45deg, #ff6b6b, #ff8e53);
            color: white;
            text-decoration: none;
            font-size: 1.3rem;
            font-weight: 600;
            border-radius: 50px;
            box-shadow: 0 10px 25px rgba(255, 107, 107, 0.5);
            transition: all 0.4s ease;
            position: relative;
            overflow: hidden;
            animation: bounce 2s infinite;
        }
        
        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
            40% { transform: translateY(-20px); }
            60% { transform: translateY(-10px); }
        }
        
        .support-btn:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(255, 107, 107, 0.7);
        }
        
        .support-btn:active {
            transform: translateY(0);
        }
        
        .support-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transition: 0.5s;
        }
        
        .support-btn:hover::before {
            left: 100%;
        }
        
        .features {
            display: flex;
            justify-content: space-around;
            margin-top: 50px;
            flex-wrap: wrap;
        }
        
        .feature {
            flex: 1;
            min-width: 200px;
            margin: 20px;
            padding: 25px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 15px;
            transition: transform 0.3s ease;
        }
        
        .feature:hover {
            transform: translateY(-10px);
        }
        
        .feature i {
            font-size: 3rem;
            margin-bottom: 20px;
            color: #ff6b6b;
        }
        
        .feature h3 {
            font-size: 1.4rem;
            margin-bottom: 15px;
        }
        
        .countdown {
            margin: 40px 0;
            font-size: 1.2rem;
        }
        
        .countdown span {
            font-weight: bold;
            color: #ff6b6b;
        }
        
        @media (max-width: 768px) {
            h1 { font-size: 2.5rem; }
            p { font-size: 1.2rem; }
            .container { padding: 30px; margin: 20px; }
            .support-btn { padding: 15px 30px; font-size: 1.1rem; }
        }
        
        .notification {
            position: fixed;
            bottom: 20px;
            right: 20px;
            padding: 15px 25px;
            background: rgba(0, 0, 0, 0.8);
            border-left: 5px solid #ff6b6b;
            border-radius: 5px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
            transform: translateX(150%);
            transition: transform 0.5s ease;
        }
        
        .notification.show {
            transform: translateX(0);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="logo">
            <i class="fas fa-cogs fa-5x"></i>
        </div>
        
        <h1>Website Offline</h1>
        
        <p>We're currently processing your orders and performing scheduled maintenance. <br>We'll be back online shortly with an improved experience!</p>
        
        <div class="countdown">
            Estimated time until completion: <span id="time">30:00</span>
        </div>
        
        <a href="support.php" class="support-btn">
            <i class="fas fa-headset"></i> Contact Support
        </a>
        
        <div class="features">
            <div class="feature">
                <i class="fas fa-truck-fast"></i>
                <h3>Order Processing</h3>
                <p>Your orders are being processed securely</p>
            </div>
            
            <div class="feature">
                <i class="fas fa-server"></i>
                <h3>System Maintenance</h3>
                <p>We're upgrading our systems for better performance</p>
            </div>
            
            <div class="feature">
                <i class="fas fa-shield-alt"></i>
                <h3>Security Updates</h3>
                <p>Implementing the latest security enhancements</p>
            </div>
        </div>
    </div>
    
    <div class="notification" id="notification">
        <i class="fas fa-info-circle"></i> Redirecting to support page...
    </div>

    <script>
        // Countdown timer
        function startTimer(duration, display) {
            let timer = duration, minutes, seconds;
            setInterval(function () {
                minutes = parseInt(timer / 60, 10);
                seconds = parseInt(timer % 60, 10);
                
                minutes = minutes < 10 ? "0" + minutes : minutes;
                seconds = seconds < 10 ? "0" + seconds : seconds;
                
                display.textContent = minutes + ":" + seconds;
                
                if (--timer < 0) {
                    timer = duration;
                }
            }, 1000);
        }
        
        window.onload = function () {
            const thirtyMinutes = 30 * 60;
            const display = document.querySelector('#time');
            startTimer(thirtyMinutes, display);
        };
        
        // Support button animation
        const supportBtn = document.querySelector('.support-btn');
        const notification = document.getElementById('notification');
        
        supportBtn.addEventListener('click', function(e) {
            e.preventDefault();
            
            // Show notification
            notification.classList.add('show');
            
            // Redirect after a short delay
            setTimeout(function() {
                window.location.href = supportBtn.getAttribute('href');
            }, 1500);
        });
        
        // Floating animation for features
        const features = document.querySelectorAll('.feature');
        features.forEach((feature, index) => {
            feature.style.animationDelay = `${index * 0.3}s`;
        });
    </script>
</body>
</html>