(function() {

    var init = function() {

		initNavAnalytics();

    };

    var initNavAnalytics = function() {

		if(!dataLayer && !digitalData) return;

        //Main Nav and SSO Links
        var $topNavLink = $("a.atvi-header_main-nav_top-nav-link");

        $topNavLink.on("click", function() {

            dataLayer.push({
                action: "main nav",
                category: "navigation",
                event: "event",
                label: $(this).data("entext") //inner text of link

            });

        });

        //Sub Nav
        var $subNavLink = $("a.atvi-header_main-nav_sub-nav-link");

        $subNavLink.on("click", function() {

            dataLayer.push({
                action: "sub nav",
                category: "navigation",
                event: "event",
                label: $(this).data("entext")

            });

        });

        //Purchase
		var $purchaseBtn = $(".atvi-header_main-cta a");

        $purchaseBtn.on("click", function() {

			dataLayer.push({
                action: "main nav",
                category: "navigation",
                event: "event",
                label: $(this).data("entext"),
                destinationUrl: $(this).attr("href")

            });

        });

        //Logo
        var $logo = $(".atvi-header_main-logo a");

        $logo.on("click", function() {

			dataLayer.push({
                action: "main nav",
                category: "navigation",
                event: "event",
                label: $(this).find("img").attr("alt"),
                destinationUrl: $(this).attr("href")

            });

        });
    };

	$(init);

})();

(function() {

    var init = function() {

        skipToMainContent();
        updateMainContent();
        initSSO();
        initAccessibility();
        initMobileMenu();
        //initScroll();
        initSearch();
		initResize();
    };

    var skipToMainContent = function() {

        var curLink = window.location.href;
        var updatedMainContentLink = curLink + "#main";
		$(".skip-to-main-content-link").attr("href", updatedMainContentLink);

    };

    var updateMainContent = function() {

		$("body > .root > .aem-Grid > .responsivegrid").wrap("<main id='main'>");

    };

    var initSSO = function() {

        setTimeout(function() {

            if(window.ssobar) updateAccountLinksFromSso();

        }, 2000);

        var sb = window.ssobar;
        if(sb) {
            sb.onAuthentication(function() {
                sb.onReady(updateAccountLinksFromSso);
            });
        }

        //Account name click handler
        $(".logged-in .account-name").on("click", function() {

            //Display account logged-in drop down links
			$(this).closest(".logged-in").toggleClass("active");

        });

    };

    var updateAccountLinksFromSso = function() {

        var $body = $("body");

        try {
            if(window.ssobar.user.isLoggedIn) {
                $body.addClass("sso-logged-in");
            }
        } catch(e) {}
        
        setTimeout(function() {
            $body.addClass("sso-auth-known"); 
        }, 20);

        var domain = $(".atvi-header-container").data("sso-domain"); //atvi, cod, crash, thps
        var loginUrl, signUpUrl, profileUrl, logOutUrl;

		//Current url we are on to append as redirect link
        var curUrl = encodeURI(window.location.href);

        //Configure sso links based on domain name
        switch(domain) {

            case "atvi": 
				loginUrl   = "https://s.activision.com/activision/login?redirectUrl=" + curUrl;
                signUpUrl  = "https://s.activision.com/activision/register";
                profileUrl = "https://s.activision.com/activision/profile";
                logOutUrl  = "https://s.activision.com/do_logout?redirectUrl=" + curUrl;
                break;
            case "crash":
                loginUrl   = "https://s.crashbandicoot.com/crash/login?redirectUrl=" + curUrl;
                signUpUrl  = "https://s.crashbandicoot.com/crash/register";
                profileUrl = "https://s.crashbandicoot.com/crash/profile";
                logOutUrl  = "https://s.crashbandicoot.com/do_logout?redirectUrl=" + curUrl;
            case "thps":
                loginUrl   = "https://s.tonyhawkthegame.com/th/login?redirectUrl=" + curUrl;
                signUpUrl  = "https://s.tonyhawkthegame.com/th/register";
                profileUrl = "https://s.tonyhawkthegame.com/th/profile";
                logOutUrl  = "https://s.tonyhawkthegame.com/do_logout?redirectUrl=" + curUrl;

        }

        //Update the four sso links
	    $(".sso-login").attr("href", loginUrl);
        $(".sso-signup").attr("href", signUpUrl);
        $(".sso-profile").attr("href", profileUrl);
        $(".sso-logout").attr("href", logOutUrl);

    };

    var initAccessibility = function() {

		//drop down accessibility
        $("span[aria-haspopup='true']").on("keyup", function(e) {

            if (e.keyCode === 13) {

				e.preventDefault();
            	
                if($(this).attr("aria-expanded") == "false") {

                    $(this).attr("aria-expanded", "true");
                    $(this).parent().addClass("active");
    
                }
                else {
                    $(this).attr("aria-expanded", "false");
                    $(this).parent().removeClass("active");
                }

            } 


        });

        //Init menubar functionality
		//var menubar = new Menubar(document.getElementById('menubar1'));
        //menubar.init();



    };

    var initMobileMenu = function() {

        //Define mobile menu button
        var $mobileMenuBtn = $("#mobile-menu-btn");

        //On mobile menu click
        $mobileMenuBtn.on("click", function() {

            if($("body").hasClass("menu-open")) closeMobileMenu();
			else openMobileMenu();

        });

        //Mobile link drop downs

        $(".atvi-header_mobile-panel li.dd > a").on("click", function(e) {

            //Prevent click through
            e.preventDefault();

            //Get li item
            var $listItem = $(this).closest("li.dd");
            //var $icon = $(this).find("> span");

			//If li item is expanded
            if($listItem.hasClass("active")) {

                //Remove "active" class to collapse it
				$listItem.removeClass("active");

                //Update aria-expanded to false
                //$icon.attr("aria-expanded", "false");
                $listItem.attr("aria-expanded", "false");

            }

            else {

                //Add "active" class to expand it
				$listItem.addClass("active");

                //Update aria-expanded to true
                //$icon.attr("aria-expanded", "true");
                $listItem.attr("aria-expanded", "true");

            }
        });

        //Mobile link drop down clicks
        $(".atvi-header_mobile-panel a").on("click", function() {

			//closeMobileMenu();

        });

    };

    var openMobileMenu = function() {

        //Get scroll window top
        var windowTop = 0 - $(window).scrollTop();

		//Add class to body
        $("body").addClass("menu-open");

        //Add styles for inset
        $("body").css("inset", windowTop + "px 0 0");

        //Update accessibility attributes
        $("#mobile-menu-btn").attr("aria-expanded", true);

        //Set all <a> tags to tabbable
        $(".atvi-header_mobile-panel a").attr("tabindex", "0");

    };

    var closeMobileMenu = function() {

		//Remove class from body
        $("body").removeClass("menu-open");

        //Update accessibility attributes
        $("#mobile-menu-btn").attr("aria-expanded", false);

        //Set all <a> tags to non-tabbable
        $(".atvi-header_mobile-panel a").attr("tabindex", "-1");

    };

    var initSearch = function() {

        //DESKTOP SEARCH
		var $desktopSearchIcon = $('.atvi-header_desktop-header .search-icon');
        var $desktopSearchInput = $('.atvi-header_desktop-header .search-input');
        var $searchForm = $('.atvi-header_search-bar-form');

        // Toggle the search input when the search icon is clicked or Enter is pressed
        $desktopSearchIcon.on('click', function() {
            toggleDesktopSearchInput($(this));
        });
        
        $desktopSearchIcon.on('keydown', function(event) {
            if (event.key === 'Enter') {
                toggleDesktopSearchInput($(this));
            }
        });

        var toggleDesktopSearchInput = function($el) {
            var isDesktopExpanded = $desktopSearchInput.attr('aria-expanded') === 'true';
            $desktopSearchInput.attr('aria-expanded', !isDesktopExpanded);
            if (!isDesktopExpanded) {
                $desktopSearchInput.focus();
            }
        };

        //MOBILE SEARCH
        var $mobileSearch = $('.atvi-header_mobile-header .atvi-header_search');
        var $mobileSearchIcon = $mobileSearch.find('.search-icon');
        var $mobileSearchField = $mobileSearch.find('.search-field');
        var $mobileSearchInput = $mobileSearch.find('.search-input');

        $mobileSearchIcon.on('click', function() {
			toggleMobileSearchInput();
        });

        $mobileSearchIcon.on('keydown', function(event) {
            if (event.key === 'Enter') {
                toggleMobileSearchInput();
            }
        });

        var toggleMobileSearchInput = function() {
            var isMobileExpanded = $mobileSearch.attr('aria-expanded') === 'true';
            $mobileSearch.attr('aria-expanded', !isMobileExpanded);
            if (!isMobileExpanded) {
                $mobileSearchInput.focus();
            }
        }

        // Handle form submission
        $searchForm.on('submit', function(event) {
            event.preventDefault();
            var that = $(this);
            var query = $(this).find(".search-input").val();
            if (query) {
                var encodedQuery = encodeURIComponent(query);
                var searchResultsPage = $(this).attr("action") + "?s=" + encodedQuery;
                window.location.href = searchResultsPage;
            }
        });

    };

    var initScroll = function() {

        var $header = $("header");
        var disabled = false;
        var delta = 0;

        var lastScrollTop = 0;

        var $blurredElements = $(".cod-global-menu, .cod-game-menu, .mobile-top-nav");

        $(window).scroll(function(e) {


            var st = $(this).scrollTop();
            
            //If we are below 300 pixels from the top of the page
            if(st > 300) {
                
                //If the current scroll top is greater than the last position
                if((st - lastScrollTop > delta) && !disabled) {

                    disabled = true;

                    $header.addClass("slideUp");

                    disabled = false;

                    // User scrolled down, so fade out the header
                    /*$header.fadeOut(function(){
						disabled = false;
                        $blurredElements.removeClass("glass");
                    });*/
                    
                }
                
                //If current scroll position is less than 30 pixels from the last scroll position
                else if((lastScrollTop - st > delta) && !disabled) {

                    disabled = true; 
					$header.removeClass("slideUp");
                    disabled = false;
                    /*$header.fadeIn(function(){
                        disabled = false;
                        $blurredElements.addClass("glass");
                    });*/
                    
                }
                
            }
            
            //Else if we are within the top 300 pixels from the top of the page
            else {

                $header.removeClass("slideUp");
                disabled = false;
                //Fade back in the header
                /*$header.fadeIn(function(){
					disabled = false;
                    $blurredElements.addClass("glass");
                });*/
            }


            lastScrollTop = st;
        });

    };

    var initResize = function() {

        var mobileBp = Number($(".atvi-header").data("mobile-bp"));

        $(window).resize(function() {

            if(window.innerWidth > mobileBp) {

                if($("body").hasClass("menu-open")) {
					closeMobileMenu();
                }

            }

        });

    };

    $(init);

})();

